# 🚀 COMPLETE RESTART GUIDE

## PROBLEM IDENTIFIED
PM2 process errored because `.env` file is missing. The application cannot load environment variables.

## SOLUTION STEPS

### 1. Copy .env File to cPanel
```bash
# Copy the .env file
cp cpanel-production/.env /home/infowasap2/public_html/.env

# Verify it exists
ls -la /home/infowasap2/public_html/.env
```

### 2. Update .env with Your Actual API Keys
Edit `/home/infowasap2/public_html/.env` and replace:
```bash
GREEN_API_ACCESS_TOKEN=your_actual_green_api_token
OPENAI_API_KEY=your_actual_openai_api_key
```

### 3. Clean Restart PM2
```bash
# Stop and delete existing process
pm2 stop whatsapp-survey-chatbot
pm2 delete whatsapp-survey-chatbot

# Navigate to app directory
cd /home/infowasap2/public_html

# Start with .env file
pm2 start server/index.js --name "whatsapp-survey-chatbot"

# Save PM2 config
pm2 save
```

### 4. Verify Startup
```bash
# Check PM2 status
pm2 list

# Check logs (should show no .env errors)
pm2 logs whatsapp-survey-chatbot --lines 20

# Test connection
curl http://localhost:3000
curl http://infowasap.my
```

## EXPECTED RESULTS

After restart:
- PM2 status should show "online" instead of "errored"
- No ".env: not found" errors in logs
- Application serves dashboard on localhost:3000
- Domain shows dashboard instead of "It works!"

## CURRENT FILES STATUS
✅ `.env` - Created with production settings
✅ `public/index.html` - Dashboard interface ready
✅ `server/index.js` - Fixed static file paths
✅ `.htaccess` - Proxy configuration ready

## API KEYS NEEDED
You'll need to add your actual:
- Green API Access Token (for WhatsApp)
- OpenAI API Key (for AI features)

The application will start but some features won't work without these keys.