# 🎯 EXACT FOLDERS TO UPLOAD TO CPANEL

## 📁 MAIN FOLDERS (Yang Awak Kena Upload):

### 1. **client/** folder - Complete React Frontend
```
client/
├── src/
│   ├── components/     <- 30+ UI components
│   ├── pages/          <- 50+ pages (dashboard, analytics, etc.)
│   ├── hooks/          <- React hooks
│   ├── lib/            <- Utilities & API functions
│   ├── types/          <- TypeScript definitions
│   ├── App.tsx         <- Main application
│   ├── main.tsx        <- Entry point
│   └── index.css       <- Styling
└── index.html          <- HTML template
```

### 2. **server/** folder - Complete Backend
```
server/
├── routes/             <- API route handlers
├── services/           <- Business logic
├── prompts/            <- AI prompts for OpenAI
├── index.ts            <- Main server file
├── db.ts               <- Database connection
├── routes.ts           <- Route definitions
├── storage.ts          <- Data storage logic
└── [other server files]
```

### 3. **shared/** folder - Common Code
```
shared/
└── schema.ts           <- Database schema & types
```

### 4. **Configuration Files** (Root Level):
```
package.json            <- Dependencies list
vite.config.ts          <- Build configuration  
tailwind.config.ts      <- Styling configuration
tsconfig.json           <- TypeScript settings
postcss.config.js       <- CSS processing
drizzle.config.ts       <- Database configuration
.env                    <- Environment variables
```

### 5. **cpanel-production/** folder - Deployment Scripts
```
cpanel-production/
├── copy-complete-original-replit.sh
├── deploy-mariadb-production.sh
└── [other deployment files]
```

## 🚀 STEP-BY-STEP UPLOAD PROCESS:

### Option 1: ZIP Upload (Easiest)
```bash
# 1. Create ZIP dari current directory
zip -r complete-replit-app.zip client/ server/ shared/ package.json vite.config.ts tailwind.config.ts tsconfig.json postcss.config.js drizzle.config.ts cpanel-production/ .env

# 2. Download ZIP file dari Replit
# 3. Upload ke cPanel File Manager: /home/infowasap2/public_html/myapp/
# 4. Extract ZIP dalam folder myapp
```

### Option 2: Individual Folder Upload
```
1. Upload folder: client/
2. Upload folder: server/
3. Upload folder: shared/
4. Upload folder: cpanel-production/
5. Upload files: package.json, vite.config.ts, tailwind.config.ts, tsconfig.json, postcss.config.js, drizzle.config.ts, .env
```

## 🔧 AFTER UPLOAD - RUN DEPLOYMENT:

```bash
# SSH ke cPanel server:
cd /home/infowasap2/public_html/myapp

# Make script executable:
chmod +x cpanel-production/copy-complete-original-replit.sh

# Run deployment script:
bash cpanel-production/copy-complete-original-replit.sh
```

## ⚡ WHAT THE SCRIPT DOES:

1. **Converts TypeScript → JavaScript**
   - client/src/App.tsx → App.jsx
   - All .tsx files → .jsx files
   - All .ts files → .js files

2. **Sets up Production Environment**
   - Installs all dependencies
   - Builds React application
   - Configures MariaDB connection
   - Starts PM2 process

3. **Preserves All Functionality**
   - All 50+ pages working
   - All 30+ components functional
   - Multi-tenant system intact
   - Same beautiful interface

## ✅ RESULT:
- **infowasap.my** - Complete original application
- **infowasap.my/dashboard** - Admin dashboard
- **All your advanced features working**
- **Connected to MariaDB database**

## 🎯 CURRENT STRUCTURE YANG AWA ADA:
```
/home/runner/workspace/
├── client/           <- ✅ Upload this
├── server/           <- ✅ Upload this  
├── shared/           <- ✅ Upload this
├── cpanel-production/ <- ✅ Upload this
├── package.json      <- ✅ Upload this
├── vite.config.ts    <- ✅ Upload this
├── tailwind.config.ts <- ✅ Upload this
├── tsconfig.json     <- ✅ Upload this
├── postcss.config.js <- ✅ Upload this
├── drizzle.config.ts <- ✅ Upload this
└── .env              <- ✅ Upload this (edit DB credentials)
```

## 🔑 IMPORTANT: Edit .env file:
```
DATABASE_URL=mysql://infowasap_myapp:YOUR_DB_PASSWORD@localhost:3306/infowasap_myapp
GREEN_API_ACCESS_TOKEN=your_actual_token
OPENAI_API_KEY=your_actual_key
```