# 🔧 QUICK DATABASE CONNECTION FIX

## PROBLEM IDENTIFIED
Database user `infowasap2_userv1` cannot connect with password `Master8899@@`

## SOLUTION OPTIONS

### Option 1: Check Actual Database Credentials (RECOMMENDED)
1. Login to cPanel
2. Go to "MySQL Databases" 
3. Look for the actual database name and username
4. Update .env file with correct credentials

### Option 2: Create New Database User
In cPanel MySQL Databases:
```
Database Name: infowasap2_v1
Username: infowasap2_userv1  
Password: Master8899@@
```

### Option 3: Quick .env Fix
Edit your .env file and update these lines:
```bash
# Try these common variations:
DB_USER=infowasap2_infowasap2_userv1
DB_PASSWORD=Master8899@@
DB_NAME=infowasap2_infowasap2_v1

# OR (if using different format):
DB_USER=infowasap2_userv1
DB_PASSWORD=your_actual_password
DB_NAME=infowasap2_v1
```

### Option 4: Test Database Connection
```bash
mysql -u infowasap2_userv1 -p'Master8899@@' -h localhost infowasap2_v1
```

## COMMON cPanel DATABASE NAMING
- Database: `cpanel_username_dbname`
- User: `cpanel_username_username`
- Example: `infowasap2_v1` becomes `infowasap2_infowasap2_v1`

## AFTER FIX
Restart server:
```bash
./start.sh
```

## STATUS
✅ All other services working (WhatsApp API, OpenAI)
❌ Only database connection needs fixing