# WhatsApp Survey Chatbot Platform - Complete cPanel Edition

**Complete multi-tenant AI-powered WhatsApp survey chatbot system for cPanel hosting with full feature set.**

## 🎯 Features Overview

### Core AI & Chatbot Features
- ✅ **OpenAI GPT-4o Integration** - Advanced conversation processing
- ✅ **Survey Intent Analysis** - Categorizes responses (high/medium/low potential, eligibility)
- ✅ **Demographic Data Extraction** - Age, gender, race, occupation, location analysis
- ✅ **Business Templates** - Pre-configured setups (Restaurant, IT Services, Healthcare, etc.)
- ✅ **Multi-language Support** - Malay, English, Chinese, Tamil
- ✅ **Interactive Messages** - Buttons, lists, rich content

### Multi-Tenant Architecture
- ✅ **Admin Dashboard** - Platform-wide management
- ✅ **Tenant Management** - Business-specific configurations
- ✅ **User Tracking** - Comprehensive user analytics
- ✅ **Role-based Access** - Admin, Manager, Viewer levels
- ✅ **Subscription Management** - Pricing plans and payment gateways

### WhatsApp Integration
- ✅ **Green API Support** - Primary WhatsApp Business API
- ✅ **Universal Bot Detection** - Prevents self-response loops
- ✅ **Webhook + Polling** - Reliable message handling
- ✅ **Interactive Messages** - Buttons, lists, multimedia
- ✅ **24-hour Window Management** - Cost-effective messaging

### Analytics & Reporting
- ✅ **Real-time Dashboard** - Live conversation stats
- ✅ **Keyword Tracking** - Popular terms and mentions
- ✅ **Lead Management** - Customer qualification tracking
- ✅ **Export Functionality** - Excel reports with charts
- ✅ **System Logging** - Comprehensive audit trails

### Production Features
- ✅ **MySQL/MariaDB** - Native cPanel database support
- ✅ **PM2 Process Management** - Auto-restart and monitoring
- ✅ **Security Hardening** - Helmet, CORS, rate limiting
- ✅ **File Management** - Upload and document processing
- ✅ **Backup System** - Automated data protection
- ✅ **Log Rotation** - Disk space management

## 🚀 Quick Installation

### Prerequisites
- Node.js 18+ installed on cPanel
- MySQL/MariaDB database access
- Green API WhatsApp Business account
- OpenAI API key
- SSL certificate (recommended)

### Installation Steps

1. **Upload files** to your cPanel public_html directory
2. **Run installation**:
   ```bash
   chmod +x install.sh
   ./install.sh
   ```
3. **Configure environment**:
   ```bash
   nano .env
   # Configure all required credentials
   ```
4. **Setup database**:
   ```bash
   node setup-database.js
   ```
5. **Start server**:
   ```bash
   pm2 start ecosystem.config.js
   ```

## 📋 Environment Configuration

Copy `.env.example` to `.env` and configure:

### Database Settings
```env
DATABASE_URL=mysql://user:password@localhost:3306/database
DB_HOST=localhost
DB_USER=your_db_user
DB_PASSWORD=your_secure_password
DB_NAME=whatsapp_chatbot
```

### WhatsApp API Settings
```env
GREEN_API_INSTANCE_ID=7105303475
GREEN_API_ACCESS_TOKEN=your_green_api_token
```

### AI & Security
```env
OPENAI_API_KEY=sk-your-openai-key
SESSION_SECRET=your-very-secure-session-secret-32-chars
ADMIN_USERNAME=admin
ADMIN_PASSWORD=##Master8899
```

### Production Settings
```env
NODE_ENV=production
PORT=3000
DOMAIN_NAME=yourdomain.com
DEFAULT_TENANT_ID=a1ffbb8c-cb66-43de-8d04-175289124254
```

## 🗄️ Database Schema (28 Tables)

The system automatically creates a comprehensive database with:

### Core Tables
- `sessions` - User session management
- `admin_users` - Platform administrators
- `tenants` - Multi-tenant organizations
- `tenant_users` - Business users
- `users` - WhatsApp end users

### Conversation Management
- `conversations` - Chat sessions
- `messages` - Individual messages
- `survey_responses` - Response analysis
- `demographics` - User demographics

### Business Intelligence
- `keywords` - Tracked keywords
- `keyword_mentions` - Keyword analytics
- `customer_leads` - Lead management
- `business_templates` - Industry templates

### System Management
- `whatsapp_providers` - API configurations
- `pricing_plans` - Subscription tiers
- `payment_gateways` - Payment processing
- `tenant_subscriptions` - Active subscriptions
- `files` - Document management
- `system_logs` - Audit trails
- `system_settings` - Configuration

## 🔗 API Endpoints

### System Endpoints
| Endpoint | Method | Description |
|----------|--------|-------------|
| `/health` | GET | Health check |
| `/api/system/status` | GET | System status |

### WhatsApp Endpoints
| Endpoint | Method | Description |
|----------|--------|-------------|
| `/api/green-api/webhook` | POST | WhatsApp webhook |
| `/api/whatsapp/send` | POST | Send message |

### Analytics Endpoints
| Endpoint | Method | Description |
|----------|--------|-------------|
| `/api/dashboard/stats` | GET | Dashboard statistics |
| `/api/analytics/keywords` | GET | Keyword analytics |
| `/api/conversations/recent` | GET | Recent conversations |

### Admin Endpoints
| Endpoint | Method | Description |
|----------|--------|-------------|
| `/api/auth/login` | POST | Admin login |
| `/api/admin/dashboard` | GET | Admin data |
| `/api/admin/templates` | GET | Business templates |
| `/api/upload` | POST | File upload |

## 🎛️ Management Scripts

### System Management
```bash
# Check system status
./check-status.sh

# Create backup
./backup.sh

# Rotate logs
./rotate-logs.sh
```

### Process Management
```bash
# Start with PM2
pm2 start ecosystem.config.js

# Monitor
pm2 status
pm2 logs whatsapp-survey-chatbot

# Restart
pm2 restart whatsapp-survey-chatbot

# Enable auto-start
pm2 startup
pm2 save
```

## 🔧 Webhook Configuration

Configure your Green API webhook URL:
```
https://yourdomain.com/api/green-api/webhook
```

### Webhook Settings
- **URL**: `https://yourdomain.com/api/green-api/webhook`
- **Events**: `incomingMessageReceived`
- **Format**: JSON
- **Method**: POST

## 📊 Admin Dashboard

Access the admin panel at: `https://yourdomain.com/admin`

### Default Credentials
- **Username**: `admin`
- **Password**: `##Master8899`

### Dashboard Features
- Real-time conversation statistics
- Keyword analytics with charts
- User demographics overview
- System health monitoring
- Business template management
- File upload and management

## 🤖 Business Templates

Pre-configured templates for different industries:

### Available Templates
1. **Restaurant & Food** - Menu, ordering, delivery
2. **IT Services** - Technical support, consultations
3. **Healthcare** - Appointments, services, emergency
4. **Beauty Salon** - Bookings, treatments, packages
5. **Retail Store** - Products, pricing, promotions
6. **Education** - Courses, enrollment, schedules
7. **Real Estate** - Properties, viewings, consultations
8. **Automotive** - Services, parts, maintenance

Each template includes:
- Industry-specific prompts
- Common keywords and responses
- Business information templates
- Customer interaction flows

## 🔍 Keyword System

### Automatic Keyword Detection
The system automatically tracks and responds to keywords:
- **Product inquiries** - Prices, availability, specifications
- **Service requests** - Bookings, appointments, support
- **General queries** - Hours, location, contact info
- **Support issues** - Complaints, feedback, help

### Keyword Analytics
- Most mentioned keywords
- Trending topics
- Response effectiveness
- User engagement metrics

## 📈 Analytics & Reporting

### Real-time Metrics
- Active conversations
- Daily message volume
- User growth trends
- Keyword popularity

### Demographic Insights
- Age distribution
- Gender breakdown
- Location analysis
- Occupation patterns

### Business Intelligence
- Lead qualification scores
- Conversion tracking
- Customer journey analysis
- Response time metrics

## 🔐 Security Features

### Access Control
- Role-based permissions
- Session management
- Rate limiting
- Input validation

### Data Protection
- Password hashing (bcrypt)
- Session encryption
- CORS protection
- Security headers

### API Security
- Request rate limiting
- Authentication required
- Input sanitization
- Error handling

## 🛠️ Troubleshooting

### Common Issues

1. **Database Connection Failed**
   ```bash
   # Check credentials
   mysql -u username -p
   
   # Test connection
   node -e "require('./server/db.js').testConnection()"
   ```

2. **WhatsApp API Errors**
   ```bash
   # Check instance status
   curl -s "https://api.green-api.com/waInstance{instance}/getStateInstance/{token}"
   
   # Test webhook
   curl -X POST https://yourdomain.com/api/green-api/webhook \
     -H "Content-Type: application/json" \
     -d '{"typeWebhook":"incomingMessageReceived","senderData":{"chatId":"test@c.us"},"messageData":{"textMessageData":{"textMessage":"test"}}}'
   ```

3. **OpenAI API Issues**
   ```bash
   # Test API key
   curl -H "Authorization: Bearer $OPENAI_API_KEY" \
     https://api.openai.com/v1/models
   ```

4. **PM2 Process Issues**
   ```bash
   # Check process status
   pm2 status
   
   # View logs
   pm2 logs whatsapp-survey-chatbot
   
   # Restart process
   pm2 restart whatsapp-survey-chatbot
   ```

### Debug Commands

```bash
# Check Node.js version
node -v

# Test database
node setup-database.js

# Check running processes
ps aux | grep node

# Monitor logs in real-time
tail -f logs/combined.log

# Check disk space
df -h

# Check memory usage
free -h
```

### Performance Optimization

1. **Database Optimization**
   - Proper indexing (automatically created)
   - Connection pooling
   - Query optimization

2. **Server Optimization**
   - PM2 cluster mode
   - Memory management
   - CPU monitoring

3. **Network Optimization**
   - Gzip compression
   - Static file caching
   - CDN for assets

## 📞 Support & Maintenance

### Regular Maintenance
- Weekly log rotation
- Monthly database optimization
- Quarterly security updates
- Annual SSL certificate renewal

### Monitoring
- PM2 process monitoring
- Database connection health
- API endpoint availability
- Disk space utilization

### Backup Strategy
- Daily automated backups
- Weekly full system backup
- Monthly long-term storage
- Off-site backup recommended

## 🎯 Deployment Checklist

- [ ] Node.js 18+ installed
- [ ] MySQL/MariaDB configured
- [ ] Environment variables set
- [ ] Database schema created
- [ ] Admin user configured
- [ ] WhatsApp webhook configured
- [ ] SSL certificate installed
- [ ] Domain name configured
- [ ] PM2 process running
- [ ] Backup system configured
- [ ] Monitoring enabled
- [ ] Security headers active

## 📄 License & Credits

This is a complete production-ready WhatsApp survey chatbot platform designed for cPanel hosting environments. Built with Node.js, Express, MySQL, and integrated with OpenAI GPT-4o for advanced AI capabilities.

**Key Technologies:**
- Node.js 18+ with ES modules
- Express.js web framework
- MySQL/MariaDB database
- OpenAI GPT-4o API
- Green API WhatsApp Business
- PM2 process management
- bcrypt security

---

**Version**: 1.0.0  
**Last Updated**: August 2025  
**Compatibility**: cPanel hosting with Node.js support