#!/bin/bash
echo "🔍 PM2 Status Check..."

echo "📊 Current PM2 List:"
pm2 list

echo ""
echo "📋 Last 20 lines of logs:"
pm2 logs whatsapp-survey-chatbot --lines 20

echo ""
echo "🔌 Port 3000 check:"
netstat -tulpn | grep :3000 || echo "No process listening on port 3000"

echo ""
echo "📁 File structure check:"
ls -la /home/infowasap2/public_html/myapp/server/index.js
ls -la /home/infowasap2/public_html/myapp/.env

echo ""
echo "🧪 Manual startup test (5 seconds):"
cd /home/infowasap2/public_html/myapp
timeout 5s node server/index.js 2>&1 | head -20