#!/bin/bash
# Database Connection Debug Script

echo "🔍 Debugging database connection..."

# Test different username formats common in cPanel
echo "Testing database connection formats..."

# Format 1: Standard cPanel format (most common)
echo "1. Testing: infowasap2_userv1"
mysql -u infowasap2_userv1 -p'Master8899@@' -e "SELECT 1;" 2>/dev/null && echo "✅ SUCCESS: infowasap2_userv1" || echo "❌ FAILED: infowasap2_userv1"

# Format 2: With account prefix
echo "2. Testing: infowasap2_infowasap2_userv1"
mysql -u infowasap2_infowasap2_userv1 -p'Master8899@@' -e "SELECT 1;" 2>/dev/null && echo "✅ SUCCESS: infowasap2_infowasap2_userv1" || echo "❌ FAILED: infowasap2_infowasap2_userv1"

# Format 3: Simple format
echo "3. Testing: userv1"
mysql -u userv1 -p'Master8899@@' -e "SELECT 1;" 2>/dev/null && echo "✅ SUCCESS: userv1" || echo "❌ FAILED: userv1"

# Show existing databases and users
echo ""
echo "📋 Checking existing databases:"
mysql -u root -e "SHOW DATABASES;" 2>/dev/null | grep -i infowasap || echo "No infowasap databases found"

echo ""
echo "👥 Checking existing users:"
mysql -u root -e "SELECT User, Host FROM mysql.user WHERE User LIKE '%infowasap%' OR User LIKE '%userv1%';" 2>/dev/null || echo "Cannot access user list (need root)"

echo ""
echo "💡 If all tests fail, check cPanel MySQL Databases section for actual username"