#!/bin/bash
# Debug myapp deployment issues

echo "🔍 Debugging myapp deployment..."

# Check current directory and PM2 status
echo "📂 Current directory:"
pwd
ls -la

echo "📋 PM2 Status:"
pm2 list

echo "📋 PM2 Logs (last 20 lines):"
pm2 logs whatsapp-survey-chatbot --lines 20

echo "📁 File structure check:"
echo "  .env file:"
ls -la .env 2>/dev/null || echo "  ❌ .env not found"
echo "  server/index.js:"
ls -la server/index.js 2>/dev/null || echo "  ❌ server/index.js not found"
echo "  package.json:"
ls -la package.json 2>/dev/null || echo "  ❌ package.json not found"

echo "🔌 Port 3000 check:"
netstat -tulpn | grep :3000 || echo "  No process on port 3000"

echo "📦 Node.js test:"
node --version

echo "🔧 Manual start test:"
echo "  Testing: node server/index.js"
timeout 5s node server/index.js 2>&1 | head -10