#!/bin/bash
# Debug startup issues

echo "🔍 Debugging application startup..."

# Check if required files exist
echo "📁 Checking file structure:"
ls -la /home/infowasap2/public_html/server/index.js
ls -la /home/infowasap2/public_html/.env
ls -la /home/infowasap2/public_html/public/index.html

# Check PM2 logs
echo "📋 PM2 logs (last 20 lines):"
pm2 logs whatsapp-survey-chatbot --lines 20

# Check if port 3000 is in use
echo "🔌 Port 3000 status:"
netstat -tulpn | grep :3000

# Test database connection
echo "🗄️ Database connection test:"
mysql -u infowasap2_userv1 -p'Master8899@@' infowasap2_v2 -e "SELECT 1;" 2>&1 | head -5

# Check Node.js version
echo "📦 Node.js version:"
node --version

# Check if all dependencies are installed
echo "📦 Checking package.json:"
ls -la /home/infowasap2/public_html/package.json

echo "✅ Debug complete!"