#!/bin/bash
# Quick deployment to myapp directory

echo "🚀 Deploying to /home/infowasap2/public_html/myapp..."

# Copy files to correct myapp location
echo "📁 Copying files..."
cp cpanel-production/.env /home/infowasap2/public_html/myapp/.env
cp -r cpanel-production/public /home/infowasap2/public_html/myapp/
cp cpanel-production/server/index.js /home/infowasap2/public_html/myapp/server/
cp cpanel-production/.htaccess /home/infowasap2/public_html/.htaccess

# Stop and restart PM2
echo "🔄 Restarting PM2..."
pm2 stop whatsapp-survey-chatbot 2>/dev/null || echo "No process to stop"
pm2 delete whatsapp-survey-chatbot 2>/dev/null || echo "No process to delete"

# Navigate to myapp and start
cd /home/infowasap2/public_html/myapp
pm2 start server/index.js --name "whatsapp-survey-chatbot"
pm2 save

echo "✅ Deployment complete!"
echo "📊 PM2 Status:"
pm2 list

echo "🔗 Test URLs:"
echo "  http://localhost:3000"
echo "  http://infowasap.my"