#!/bin/bash
echo "🔧 Quick Fix & Deploy for Missing API Keys Issue"

# Copy all required files to myapp directory
echo "📁 Copying deployment files..."
cp cpanel-production/.env /home/infowasap2/public_html/myapp/.env
cp -r cpanel-production/public /home/infowasap2/public_html/myapp/
cp cpanel-production/server/index.js /home/infowasap2/public_html/myapp/server/
cp cpanel-production/.htaccess /home/infowasap2/public_html/.htaccess

# Stop PM2 cleanly
echo "⏹️ Stopping PM2 process..."
pm2 stop whatsapp-survey-chatbot 2>/dev/null || echo "No process to stop"
pm2 delete whatsapp-survey-chatbot 2>/dev/null || echo "No process to delete"

# Navigate to myapp directory
cd /home/infowasap2/public_html/myapp

# Verify .env file exists
echo "🔍 Checking .env file..."
if [ -f ".env" ]; then
    echo "✅ .env file found"
    ls -la .env
else
    echo "❌ .env file missing - creating basic one..."
    cat > .env << 'EOF'
NODE_ENV=production
PORT=3000
DB_HOST=localhost
DB_PORT=3306
DB_USER=infowasap2_userv1
DB_PASSWORD=Master8899@@
DB_NAME=infowasap2_v2
SESSION_SECRET=production-session-secret-key-change-this
GREEN_API_INSTANCE_ID=7105303475
GREEN_API_ACCESS_TOKEN=your_green_api_token_here
OPENAI_API_KEY=your_openai_api_key_here
EOF
fi

# Start PM2 from myapp directory
echo "🚀 Starting PM2 process..."
pm2 start server/index.js --name "whatsapp-survey-chatbot"
pm2 save

# Wait a moment for startup
sleep 3

# Check results
echo "📊 Final Status:"
pm2 list
echo ""
echo "🔗 Test URLs:"
echo "  curl http://localhost:3000"
echo "  curl http://infowasap.my"
echo ""
echo "📋 Check logs: pm2 logs whatsapp-survey-chatbot"