-- Complete database reimport with UTF-8 emoji support
-- Run this to fix the icon display issue

-- Set proper UTF-8 encoding
SET NAMES utf8mb4 COLLATE utf8mb4_unicode_ci;
SET CHARACTER SET utf8mb4;

-- Drop existing database and recreate with proper charset
DROP DATABASE IF EXISTS infowasap2_v1;
CREATE DATABASE infowasap2_v1 CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;

-- Use the database
USE infowasap2_v1;

-- Set encoding for this session
SET NAMES utf8mb4 COLLATE utf8mb4_unicode_ci;

-- Now import the complete database
SOURCE database.sql;

-- Verify business templates have proper icons
SELECT id, name, icon FROM business_templates ORDER BY id;