#!/bin/bash
# Complete application restart script

echo "🔄 Restarting WhatsApp Survey Bot..."

# Check PM2 status
echo "📋 Current PM2 status:"
pm2 list

# Stop existing process if running
echo "🛑 Stopping existing proceass..."
pm2 stop whatsapp-survey-chatbot 2>/dev/null || echo "No existing process found"
pm2 delete whatsapp-survey-chatbot 2>/dev/null || echo "No process to delete"

# Copy updated files
echo "📁 Copying updated files..."
cp -r cpanel-production/public /home/infowasap2/public_html/ 2>/dev/null || echo "Public files already in place"
cp cpanel-production/server/index.js /home/infowasap2/public_html/server/ 2>/dev/null || echo "Server file already updated"
cp cpanel-production/.htaccess /home/infowasap2/public_html/ 2>/dev/null || echo "htaccess already in place"

# Navigate to app directory
cd /home/infowasap2/public_html

# Start the application with PM2
echo "🚀 Starting application..."
pm2 start server/index.js --name "whatsapp-survey-chatbot" --env-file .env

# Save PM2 configuration
pm2 save

# Show status
echo "📊 Final PM2 status:"
pm2 list

echo "✅ Application restart complete!"
echo "🌐 Test: curl http://localhost:3000"
echo "🔗 Domain: http://infowasap.my"