import express from 'express';
import bcrypt from 'bcryptjs';

const router = express.Router();

// Login endpoint
router.post('/login', async (req, res) => {
  try {
    const { username, password } = req.body;

    if (!username || !password) {
      return res.status(400).json({ error: 'Username and password are required' });
    }

    // For demo purposes, hardcoded admin credentials
    // In production, this would query your database
    if (username === 'admin') {
      const isValid = await bcrypt.compare(password, '$2a$12$8l9FZjHCi5aGGz8xrjCOruXEKDzNd4zDQGpPCJJ0UdCJvL8kqPGt6'); // ##Master8899
      
      if (isValid) {
        req.session.user = {
          id: 'admin-id',
          username: 'admin',
          role: 'admin',
          tenantId: 'default-tenant'
        };

        res.json({
          success: true,
          user: {
            id: 'admin-id',
            username: 'admin',
            role: 'admin'
          }
        });
      } else {
        res.status(401).json({ error: 'Invalid credentials' });
      }
    } else {
      res.status(401).json({ error: 'User not found' });
    }
  } catch (error) {
    console.error('Login error:', error);
    res.status(500).json({ error: 'Login failed' });
  }
});

// Logout endpoint
router.post('/logout', (req, res) => {
  req.session.destroy((err) => {
    if (err) {
      return res.status(500).json({ error: 'Logout failed' });
    }
    res.json({ success: true });
  });
});

// Get current user
router.get('/user', (req, res) => {
  if (req.session.user) {
    res.json(req.session.user);
  } else {
    res.status(401).json({ error: 'Not authenticated' });
  }
});

// Middleware to check authentication
export const requireAuth = (req, res, next) => {
  if (req.session.user) {
    next();
  } else {
    res.status(401).json({ error: 'Authentication required' });
  }
};

export default router;