import express from 'express';

const router = express.Router();

// Get dashboard statistics
router.get('/stats', async (req, res) => {
  try {
    // In production, these would come from your database
    const stats = {
      activeConversations: 134,
      documentsProcessed: 89,
      totalMessages: 2156,
      responseRate: 95.2,
      newConversationsToday: 23,
      averageResponseTime: "2.3 minutes",
      topKeywords: ['aircond', 'servis', 'business'],
      conversionRate: 12.5
    };

    res.json(stats);
  } catch (error) {
    console.error('Dashboard stats error:', error);
    res.status(500).json({ error: 'Failed to fetch dashboard stats' });
  }
});

// Get recent conversations
router.get('/conversations/recent', async (req, res) => {
  try {
    const conversations = [
      {
        id: 'conv1',
        customerName: 'Ahmad Hassan', 
        customerPhone: '+60123456789',
        lastMessage: 'Saya nak tanya pasal servis aircond untuk rumah',
        timestamp: new Date().toISOString(),
        status: 'active',
        businessPotential: 'high'
      },
      {
        id: 'conv2',
        customerName: 'Siti Aminah',
        customerPhone: '+60134567890', 
        lastMessage: 'Boleh saya dapatkan quotation untuk catering business?',
        timestamp: new Date(Date.now() - 300000).toISOString(),
        status: 'pending',
        businessPotential: 'medium'
      },
      {
        id: 'conv3',
        customerName: 'Lim Wei Ming',
        customerPhone: '+60145678901',
        lastMessage: 'I want to start online business, need advice',
        timestamp: new Date(Date.now() - 600000).toISOString(), 
        status: 'completed',
        businessPotential: 'high'
      }
    ];

    res.json(conversations);
  } catch (error) {
    console.error('Recent conversations error:', error);
    res.status(500).json({ error: 'Failed to fetch conversations' });
  }
});

// Get analytics data
router.get('/analytics/keywords', async (req, res) => {
  try {
    const keywords = [
      { id: '1', keyword: 'aircond', count: 45, channel: 'whatsapp', trend: '+12%' },
      { id: '2', keyword: 'servis', count: 32, channel: 'whatsapp', trend: '+8%' },
      { id: '3', keyword: 'business', count: 28, channel: 'whatsapp', trend: '+15%' },
      { id: '4', keyword: 'catering', count: 24, channel: 'whatsapp', trend: '+5%' },
      { id: '5', keyword: 'online', count: 19, channel: 'whatsapp', trend: '+22%' }
    ];

    res.json(keywords);
  } catch (error) {
    console.error('Keywords analytics error:', error);
    res.status(500).json({ error: 'Failed to fetch keywords analytics' });
  }
});

// Get business potential analytics
router.get('/analytics/business-potential', async (req, res) => {
  try {
    const analytics = {
      high: 45,
      medium: 67,
      low: 22,
      totalAssessed: 134,
      categories: [
        { name: 'Home Services', count: 38, potential: 'high' },
        { name: 'Food & Beverage', count: 29, potential: 'medium' },
        { name: 'Online Business', count: 26, potential: 'high' },
        { name: 'Retail', count: 18, potential: 'medium' },
        { name: 'Professional Services', count: 23, potential: 'high' }
      ]
    };

    res.json(analytics);
  } catch (error) {
    console.error('Business potential analytics error:', error);
    res.status(500).json({ error: 'Failed to fetch business analytics' });
  }
});

// Get system status
router.get('/system/status', async (req, res) => {
  try {
    const status = {
      whatsapp: 'online',
      openai: process.env.OPENAI_API_KEY && process.env.OPENAI_API_KEY !== 'sk-dummy-key-for-startup-only' ? 'online' : 'offline',
      database: 'connected',
      uptime: '2d 14h 32m',
      lastBackup: new Date(Date.now() - 86400000).toISOString(),
      messagesProcessed: 2156,
      errorRate: 0.02
    };

    res.json(status);
  } catch (error) {
    console.error('System status error:', error);
    res.status(500).json({ error: 'Failed to fetch system status' });
  }
});

export default router;