// Business templates data for quick setup
export const businessTemplatesData = [
  {
    name: "Restoran & Makanan",
    category: "food",
    description: "Template untuk restoran, kedai makan, dan food delivery",
    icon: "🍽️",
    prompts: [
      {
        type: "system",
        language: "ms",
        title: "Arahan Sistem Restoran",
        content: "Anda adalah AI assistant untuk restoran. Anda membantu pelanggan dengan:\\n- Maklumat menu dan harga\\n- Tempahan meja\\n- Delivery dan takeaway\\n- Waktu operasi\\n- Promosi terkini\\n\\nSelalu mesra, professional dan promosi makanan dengan cara yang menarik. Guna emoji makanan yang sesuai."
      },
      {
        type: "company_info", 
        language: "ms",
        title: "Maklumat Restoran",
        content: "🍽️ **[NAMA RESTORAN]**\\n📍 Alamat: [ALAMAT LENGKAP]\\n📞 Telefon: [NOMBOR TELEFON]\\n⏰ Waktu: [WAKTU OPERASI]\\n🚗 Delivery: [YA/TIDAK]\\n💳 Pembayaran: [TUNAI/CARD/EWALLET]"
      }
    ],
    keywords: [
      { keyword: "menu", response: "🍽️ **MENU POPULAR KAMI:**\\n\\n🍛 Nasi Ayam - RM12\\n🍜 Mee Goreng - RM8\\n🥤 Teh Ais - RM3\\n\\nNak tengok full menu? Boleh WhatsApp kami di [NOMBOR]!", category: "product", language: "ms" },
      { keyword: "harga", response: "💰 **SENARAI HARGA:**\\n\\n🍛 Makanan utama: RM8-15\\n🥤 Minuman: RM3-6\\n🍰 Dessert: RM5-8\\n\\n*Harga termasuk cukai*", category: "pricing", language: "ms" },
      { keyword: "delivery", response: "🚗 **DELIVERY SERVICE:**\\n\\n✅ Kawasan delivery: 10km radius\\n💵 Caj delivery: RM3-5\\n⏰ Masa delivery: 30-45 minit\\n📱 Order: WhatsApp atau Grab/FoodPanda", category: "delivery", language: "ms" },
      { keyword: "booking", response: "📅 **TEMPAHAN MEJA:**\\n\\nBoleh book meja untuk:\\n🕐 Lunch: 12pm-3pm\\n🕕 Dinner: 6pm-10pm\\n\\nWhatsApp nama, tarikh, masa & berapa orang ya! 😊", category: "support", language: "ms" },
      { keyword: "waktu", response: "⏰ **WAKTU OPERASI:**\\n\\n📅 Isnin-Ahad: 10am-10pm\\n🚫 Tutup: Hari Raya & public holiday\\n\\n*Last order 9:30pm*", category: "general", language: "ms" }
    ]
  },
  
  {
    name: "Alesa IT Services",
    category: "technology", 
    description: "Template untuk Alesa IT Services - Peneraju AI Chatbot di Malaysia",
    icon: "🤖",
    prompts: [
      {
        type: "system",
        language: "ms",
        title: "Arahan Sistem Alesa IT",
        content: "Anda adalah AI assistant untuk Alesa IT Services, syarikat teknologi terkemuka di Malaysia yang pakar dalam:\\n- AI Chatbot & WhatsApp Business\\n- Sistem Pengurusan Pelanggan (CRM)\\n- E-commerce & Website Development\\n- Digital Marketing Solutions\\n\\nSelalu professional, knowledgeable dan tunjukkan expertise kami dalam teknologi terkini."
      },
      {
        type: "company_info",
        language: "ms", 
        title: "Maklumat Alesa IT Services",
        content: "🤖 **ALESA IT SERVICES**\\n🏢 Peneraju AI Chatbot di Malaysia\\n📍 Kuala Lumpur, Malaysia\\n📞 WhatsApp: +60 11-2345 6789\\n🌐 Website: www.alesa.my\\n💼 Khidmat: AI Chatbot, CRM, E-commerce, Digital Marketing"
      }
    ],
    keywords: [
      { keyword: "chatbot", response: "🤖 **AI CHATBOT SOLUTIONS:**\\n\\n✅ WhatsApp Business Integration\\n✅ Multi-language Support\\n✅ 24/7 Customer Service\\n✅ Lead Generation & Analytics\\n\\n💰 Pakej dari RM299/bulan\\n📞 Free consultation: WhatsApp kami!", category: "product", language: "ms" },
      { keyword: "harga", response: "💰 **PAKEJ HARGA KAMI:**\\n\\n🥉 Basic: RM299/bulan\\n🥈 Professional: RM599/bulan\\n🥇 Enterprise: RM999/bulan\\n\\n✅ Termasuk setup, training & support\\n📞 Hubungi untuk quote khusus!", category: "pricing", language: "ms" },
      { keyword: "whatsapp", response: "📱 **WHATSAPP BUSINESS API:**\\n\\n✅ Verified Business Account\\n✅ Automated Responses\\n✅ Broadcast Messages\\n✅ Customer Analytics\\n✅ Integration dengan CRM\\n\\nBoleh process 1000+ customers serentak!", category: "product", language: "ms" },
      { keyword: "crm", response: "📊 **CUSTOMER MANAGEMENT SYSTEM:**\\n\\n✅ Customer Database\\n✅ Sales Pipeline\\n✅ Automated Follow-up\\n✅ Reporting & Analytics\\n✅ WhatsApp Integration\\n\\nStreamline your business process!", category: "product", language: "ms" },
      { keyword: "demo", response: "🎯 **FREE DEMO AVAILABLE:**\\n\\n✅ Live system demonstration\\n✅ Custom solution consultation\\n✅ ROI calculation\\n✅ Implementation planning\\n\\n📅 Book demo slot: WhatsApp kami sekarang!", category: "support", language: "ms" }
    ]
  },

  {
    name: "Klinik Kesihatan",
    category: "healthcare",
    description: "Template untuk klinik, hospital, dan perkhidmatan kesihatan",
    icon: "🏥",
    prompts: [
      {
        type: "system",
        language: "ms", 
        title: "Arahan Sistem Klinik",
        content: "Anda adalah AI assistant untuk klinik kesihatan. Anda membantu pesakit dengan:\\n- Temujanji dan slot available\\n- Maklumat perkhidmatan & rawatan\\n- Waktu operasi dan lokasi\\n- Emergency contact\\n\\nSelalu professional, empathetic dan prioritize kesihatan pesakit."
      },
      {
        type: "company_info",
        language: "ms",
        title: "Maklumat Klinik", 
        content: "🏥 **[NAMA KLINIK]**\\n📍 Alamat: [ALAMAT LENGKAP]\\n📞 Telefon: [NOMBOR TELEFON]\\n⏰ Waktu: [WAKTU OPERASI]\\n🚨 Emergency: [NOMBOR EMERGENCY]\\n💳 Panel: [SENARAI PANEL]"
      }
    ],
    keywords: [
      { keyword: "temujanji", response: "📅 **APPOINTMENT BOOKING:**\\n\\n🕐 Slot available:\\n• Pagi: 9am-12pm\\n• Petang: 2pm-5pm\\n• Malam: 7pm-9pm\\n\\nWhatsApp nama, tarikh & masa yang dikehendaki!", category: "support", language: "ms" },
      { keyword: "emergency", response: "🚨 **EMERGENCY CONTACT:**\\n\\n📞 Emergency Hotline: [NOMBOR]\\n🏥 24-hour service available\\n🚑 Ambulance: 999\\n\\n*Untuk emergency, sila call terus atau datang ke klinik*", category: "support", language: "ms" },
      { keyword: "panel", response: "💳 **PANEL INSURANCE:**\\n\\n✅ BUPA\\n✅ Great Eastern\\n✅ Allianz\\n✅ AIA\\n✅ Prudential\\n\\nBawa kad insurance dan IC untuk rawatan panel!", category: "general", language: "ms" },
      { keyword: "vaksin", response: "💉 **VACCINATION SERVICES:**\\n\\n✅ COVID-19 vaccine\\n✅ Flu vaccine\\n✅ Travel vaccination\\n✅ Baby immunization\\n\\nSila buat appointment untuk vaccination!", category: "product", language: "ms" },
      { keyword: "checkup", response: "🔍 **HEALTH CHECKUP:**\\n\\n✅ Basic health screening\\n✅ Blood test\\n✅ X-ray\\n✅ ECG\\n\\nPackage dari RM150. Appointment required!", category: "product", language: "ms" }
    ]
  },

  {
    name: "Salon Kecantikan", 
    category: "beauty",
    description: "Template untuk salon, spa, dan perkhidmatan kecantikan",
    icon: "💄",
    prompts: [
      {
        type: "system",
        language: "ms",
        title: "Arahan Sistem Salon",
        content: "Anda adalah AI assistant untuk salon kecantikan. Anda membantu pelanggan dengan:\\n- Booking appointment dan available slots\\n- Maklumat treatment dan pakej\\n- Harga dan promosi\\n- Beauty tips dan consultation\\n\\nSelalu friendly, professional dan promote self-care."
      },
      {
        type: "company_info",
        language: "ms",
        title: "Maklumat Salon",
        content: "💄 **[NAMA SALON]**\\n📍 Alamat: [ALAMAT LENGKAP]\\n📞 Telefon: [NOMBOR TELEFON]\\n⏰ Waktu: [WAKTU OPERASI]\\n👩‍🦱 Stylist: [NAMA STYLIST]\\n💳 Pembayaran: [CASH/CARD/EWALLET]"
      }
    ],
    keywords: [
      { keyword: "facial", response: "✨ **FACIAL TREATMENTS:**\\n\\n💎 Diamond Facial - RM180\\n🌿 Organic Facial - RM120\\n💧 Hydrating Facial - RM100\\n🧖‍♀️ Anti-aging Facial - RM200\\n\\nTermasuk consultation & after-care!", category: "product", language: "ms" },
      { keyword: "hair", response: "💇‍♀️ **HAIR SERVICES:**\\n\\n✂️ Cut & Style - RM50\\n🎨 Hair Color - RM150\\n💫 Rebonding - RM280\\n🌊 Hair Perm - RM200\\n💆‍♀️ Hair Treatment - RM80", category: "product", language: "ms" },
      { keyword: "booking", response: "📅 **APPOINTMENT BOOKING:**\\n\\nAvailable slots:\\n🕐 Morning: 10am-12pm\\n🕑 Afternoon: 2pm-5pm\\n🕕 Evening: 6pm-8pm\\n\\nWhatsApp nama, service & preferred time!", category: "support", language: "ms" },
      { keyword: "package", response: "💝 **BEAUTY PACKAGES:**\\n\\n👸 Bridal Package - RM800\\n✨ Monthly Package - RM300\\n🎉 Birthday Special - RM150\\n👭 Couple Package - RM250\\n\\n*Semua pakej dapat discount!*", category: "pricing", language: "ms" },
      { keyword: "promo", response: "🎉 **PROMOSI TERKINI:**\\n\\n🔥 First timer 20% off\\n💯 Refer friend dapat RM50\\n🎂 Birthday month special price\\n📱 Follow IG untuk exclusive deals!", category: "general", language: "ms" }
    ]
  },

  {
    name: "Kedai Runcit",
    category: "retail",
    description: "Template untuk kedai runcit, grocery, dan retail store",
    icon: "🛒",
    prompts: [
      {
        type: "system",
        language: "ms",
        title: "Arahan Sistem Kedai",
        content: "Anda adalah AI assistant untuk kedai runcit. Anda membantu pelanggan dengan:\\n- Stock availability dan harga\\n- Delivery service\\n- Promosi dan discount\\n- Store location dan waktu\\n\\nSelalu helpful, update stock status, dan promote deals."
      },
      {
        type: "company_info",
        language: "ms", 
        title: "Maklumat Kedai",
        content: "🛒 **[NAMA KEDAI]**\\n📍 Alamat: [ALAMAT LENGKAP]\\n📞 Telefon: [NOMBOR TELEFON]\\n⏰ Waktu: [WAKTU OPERASI]\\n🚗 Parking: [ADA/TIADA]\\n💳 Pembayaran: [CASH/CARD/EWALLET]"
      }
    ],
    keywords: [
      { keyword: "beras", response: "🌾 **BERAS VARIETIES:**\\n\\n🥇 Beras Super Special AAA - RM3.20/kg\\n🥈 Beras Wangi Thailand - RM4.50/kg\\n🥉 Beras Tempatan - RM2.80/kg\\n\\nStock available, free delivery min RM50!", category: "product", language: "ms" },
      { keyword: "minyak", response: "🛢️ **COOKING OIL:**\\n\\n🌻 Minyak Masak 2kg - RM8.90\\n🥥 Minyak Kelapa 1kg - RM12.50\\n🫒 Olive Oil 500ml - RM15.90\\n\\nBest quality, competitive price!", category: "product", language: "ms" },
      { keyword: "delivery", response: "🚗 **DELIVERY SERVICE:**\\n\\n✅ Min order: RM30\\n💵 Caj delivery: RM5\\n⏰ Same day delivery\\n📍 Kawasan: 5km radius\\n\\nWhatsApp list barang ya!", category: "delivery", language: "ms" },
      { keyword: "promo", response: "🎉 **PROMOSI TERKINI:**\\n\\n🔥 Buy 2 Free 1 selected items\\n💰 Member discount 5-10%\\n📦 Bulk order discount\\n🎁 Weekly special deals\\n\\nTanya untuk detail!", category: "general", language: "ms" }
    ]
  }
];

// Function to seed business templates to database
export async function seedBusinessTemplates(storage) {
  try {
    console.log('🔄 Seeding business templates...');
    
    for (const template of businessTemplatesData) {
      // This would insert into business_templates table
      // Implementation depends on your storage layer
      console.log(`📝 Template: ${template.name}`);
    }
    
    console.log('✅ Business templates seeded successfully!');
  } catch (error) {
    console.error('❌ Failed to seed business templates:', error);
  }
}

export default businessTemplatesData;