# COMPLETE REPLIT TO CPANEL TRANSFER GUIDE

## 🎯 Folders Yang Kena Upload Ke cPanel

### 1. MAIN FOLDERS (WAJIB):
```
📁 client/                    <- Complete React frontend (50+ pages)
📁 server/                    <- Backend dengan all routes & services  
📁 shared/                    <- Database schema & types
📁 cpanel-production/         <- Deployment scripts
📁 migrations/                <- Database migrations (optional)
```

### 2. CONFIGURATION FILES (WAJIB):
```
📄 package.json              <- Dependencies list
📄 vite.config.ts            <- Build configuration
📄 tailwind.config.ts        <- Styling configuration
📄 tsconfig.json            <- TypeScript settings
📄 postcss.config.js        <- CSS processing
📄 .env                     <- Environment variables
📄 drizzle.config.ts        <- Database configuration
```

### 3. COMPLETE FILE STRUCTURE YANG KENA COPY:
```
/root/your-replit-project/
├── client/
│   ├── src/
│   │   ├── components/      <- ALL 30+ UI components
│   │   ├── pages/           <- ALL 50+ pages
│   │   ├── hooks/           <- React hooks
│   │   ├── lib/             <- Utilities
│   │   ├── types/           <- TypeScript types
│   │   ├── App.tsx          <- Main app
│   │   ├── main.tsx         <- Entry point
│   │   └── index.css        <- Styles
│   └── index.html           <- HTML template
├── server/
│   ├── routes/              <- API routes
│   ├── services/            <- Business logic
│   ├── prompts/             <- AI prompts
│   ├── index.ts             <- Main server
│   ├── db.ts                <- Database connection
│   ├── routes.ts            <- Route definitions
│   └── storage.ts           <- Data storage
├── shared/
│   └── schema.ts            <- Database schema
├── package.json
├── vite.config.ts
├── tailwind.config.ts
├── tsconfig.json
└── .env
```

## 🚀 STEPS UNTUK TRANSFER

### Method 1: ZIP & Upload (Recommended)
```bash
# 1. Create ZIP file dari Replit
cd /root
zip -r complete-whatsapp-bot.zip client/ server/ shared/ package.json vite.config.ts tailwind.config.ts tsconfig.json postcss.config.js drizzle.config.ts cpanel-production/

# 2. Download ZIP file dari Replit
# 3. Upload ZIP ke cPanel File Manager
# 4. Extract di /home/infowasap2/public_html/myapp/
```

### Method 2: Direct Copy (Advanced)
```bash
# Run this command DALAM Replit Shell:
rsync -av --progress \
  client/ server/ shared/ \
  package.json vite.config.ts tailwind.config.ts tsconfig.json \
  your-cpanel-server:/home/infowasap2/public_html/myapp/
```

## 🔧 AFTER UPLOAD - RUN DEPLOYMENT

```bash
# Masuk ke cPanel terminal:
cd /home/infowasap2/public_html/myapp

# Run deployment script:
bash cpanel-production/copy-complete-original-replit.sh
```

## ⚠️ IMPORTANT FILES YANG MESTI ADA:

1. **client/src/pages/** - All 50+ pages:
   - dashboard.tsx, analytics.tsx, conversations.tsx
   - tenant-dashboard.tsx, agency-dashboard.tsx
   - admin-central-dashboard.tsx, etc.

2. **client/src/components/** - All UI components:
   - ui/ folder with 30+ components
   - dashboard/ components
   - layout/ components

3. **server/** - Complete backend:
   - index.ts (main server)
   - routes/ folder dengan all API endpoints
   - services/ folder dengan business logic

4. **shared/schema.ts** - Database schema dengan all tables

## 🎯 WHAT THE SCRIPT WILL DO:

1. Convert .tsx → .jsx (untuk cPanel compatibility)
2. Convert .ts → .js (remove TypeScript)
3. Setup production dependencies
4. Connect to MariaDB database
5. Build & deploy complete application

## ✅ RESULT:
- Complete original application running on infowasap.my
- All 50+ pages working
- Multi-tenant system functional
- Connected to MariaDB database
- Same beautiful interface as Replit